/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.client.screen.handler;

import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import de.cristelknight.doapi.client.recipebook.handler.AbstractRecipeBookGUIScreenHandler;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.satisfyu.meadow.client.recipebook.group.CheeseFormRecipeBookGroup;
import net.satisfyu.meadow.recipes.cheese.CheeseFormRecipe;
import net.satisfyu.meadow.registry.ScreenHandlerRegistry;

public class CheeseFormGuiHandler
extends AbstractRecipeBookGUIScreenHandler {
    public CheeseFormGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(1));
    }

    public CheeseFormGuiHandler(int syncId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super((MenuType)ScreenHandlerRegistry.CHEESE_FORM_SCREEN_HANDLER.get(), syncId, 2, playerInventory, inventory, propertyDelegate);
        this.buildBlockEntityContainer(playerInventory, inventory);
        this.buildPlayerContainer(playerInventory);
    }

    private void buildBlockEntityContainer(Inventory playerInventory, Container inventory) {
        this.m_38897_((Slot)new FurnaceResultSlot(playerInventory.f_35978_, inventory, 0, 123, 34));
        this.m_38897_(new Slot(inventory, 1, 33, 33));
        this.m_38897_(new Slot(inventory, 2, 51, 33));
    }

    private void buildPlayerContainer(Inventory playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public int getScaledXProgress() {
        int progress = this.propertyDelegate.m_6413_(0);
        int totalProgress = 1800;
        if (progress == 0) {
            return 0;
        }
        return progress * 22 / 1800 + 1;
    }

    public int getScaledYProgress() {
        int progress = this.propertyDelegate.m_6413_(0);
        int totalProgress = 1800;
        if (progress == 0) {
            return 0;
        }
        return progress * 24 / 1800 + 1;
    }

    public List<IRecipeBookGroup> getGroups() {
        return CheeseFormRecipeBookGroup.CHEESE_GROUPS;
    }

    public boolean hasIngredient(Recipe<?> recipe) {
        if (recipe instanceof CheeseFormRecipe) {
            CheeseFormRecipe cheeseFormRecipe = (CheeseFormRecipe)recipe;
            for (Ingredient ingredient : cheeseFormRecipe.m_7527_()) {
                boolean found = false;
                for (Slot slot : this.f_38839_) {
                    if (!ingredient.test(slot.m_7993_())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getCraftingSlotCount() {
        return 2;
    }
}

